/*****************************************************************************
* This  file is used to configure FSL Profile. Normally set
* through BeeKit (called properties), but can be edited manually. A new export
* from BeeKit will overwrite this file.
*
* Copyright (c) 2009, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
*****************************************************************************/

#ifndef _FSL_PROFILE_CONFIG_H_
#define _FSL_PROFILE_CONFIG_H_


/*****************************************************************************
******************************************************************************
* Public macros
******************************************************************************
*****************************************************************************/

/* Configurable values related to the FragTxRx feature of the FSL private profile */

/* Size of the buffer to be used for transmitting and receiving 
   fragmented information */
#ifndef gFSLProfileFragTxRxBufferLength_c   
#define gFSLProfileFragTxRxBufferLength_c     512
#endif /* gFSLProfileFragTxRxBufferLength_c */


/* Number of menu entries the current device can display */
#ifndef gMaxMenuEntriesToDisplay_c   
#define gMaxMenuEntriesToDisplay_c            6
#endif /* gMaxMenuEntriesToDisplay_c */

/* Otap client wait response time */
#ifndef gProfileOtapClientWaitRespTimeout_c
#define gProfileOtapClientWaitRespTimeout_c  5000
#endif

/* Otap client maximum retries number */
#ifndef gOtapClientMaxRetries_c
#define gOtapClientMaxRetries_c 5
#endif
/*******************************************************************************
********************************************************************************
* Public prototypes
********************************************************************************
*******************************************************************************/


/****************************************************************************
*****************************************************************************
* Public type definitions
******************************************************************************
*****************************************************************************/

/****************************************************************************
*****************************************************************************
* Public memory declarations
*****************************************************************************
****************************************************************************/


/****************************************************************************
*****************************************************************************
* Public functions
*****************************************************************************
****************************************************************************/

#endif /* _FSL_PROFILE_CONFIG_H_ */
